<?php
require_once __DIR__."/../config/db.php";
$id=intval($_GET['id']??0);
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Заказ #<?=$id?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <h2>Заказ #<?=$id?></h2>
  <div id="box" class="notice">Загрузка...</div>
  <a class="btn btn-ghost" href="index.php" style="display:block; margin-top:10px; text-align:center">Вернуться в меню</a>
</div>

<script>
function load(){
  fetch("api/order_status.php?id=<?=$id?>")
    .then(r=>r.json())
    .then(d=>{
      if(!d.ok) return;
      const o=d.order;
      document.getElementById("box").innerHTML=`
        <div>Компьютер: <b>${o.pc_number}</b> (${o.hall_name||''})</div>
        <div>Статус: <span class="status-pill ${o.status}">${o.status_ru}</span></div>
        <div>Сумма: <b>${o.total} ₸</b> (включая сервис)</div>
        <div class="muted">Обновляется автоматически</div>
      `;
    });
}
load(); setInterval(load,2000);
</script>
</body>
</html>
