<?php require_once __DIR__."/../config/db.php"; ?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Triumph Menu</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo">TRIUMPH • Menu</div>
    <div class="badge">Сервис 10% включится в чек</div>
  </div>

  <input class="input" id="search" placeholder="Поиск по меню...">

  <div class="tabs" id="tabs"></div>
  <div class="grid" id="grid"></div>
</div>

<a class="cart-fab" href="cart.php">Корзина (0)</a>

<script src="/assets/js/app.js"></script>
<script>
const pcParam = new URLSearchParams(location.search).get("pc");
if(pcParam) localStorage.setItem("pc_number", pcParam);

let foods=[], categories=[], activeCat="all";

function renderTabs(){
  const t = document.getElementById("tabs");
  t.innerHTML = "";
  const allBtn = document.createElement("div");
  allBtn.className = "tab active";
  allBtn.innerText = "Все";
  allBtn.onclick = ()=>{activeCat="all"; renderTabs(); renderGrid();}
  t.appendChild(allBtn);

  categories.forEach(c=>{
    const b = document.createElement("div");
    b.className = "tab"+(activeCat==c.id?" active":"");
    b.innerText = c.name;
    b.onclick = ()=>{activeCat=c.id; renderTabs(); renderGrid();}
    t.appendChild(b);
  });
}

function renderGrid(){
  const g = document.getElementById("grid");
  const s = document.getElementById("search").value.toLowerCase();
  g.innerHTML = "";
  foods
    .filter(f=>activeCat=="all" || f.category_id==activeCat)
    .filter(f=>f.name.toLowerCase().includes(s))
    .forEach(f=>{
      const card=document.createElement("div");
      card.className="card";
      card.innerHTML=`
        <img src="${f.image_url||'/assets/img/placeholder.jpg'}">
        <div class="card-body">
          <div class="card-title">${f.name}</div>
          <div class="row">
            <div class="price">${f.price} ₸</div>
            <div class="space"></div>
            ${f.is_available==1 ? `<button class="btn btn-accent">Добавить</button>` : `<div class="muted">На стопе</div>`}
          </div>
          <button class="btn btn-ghost" style="width:100%" onclick="location.href='item.php?id=${f.id}'">Подробнее</button>
        </div>
      `;
      if(f.is_available==1){
        card.querySelector(".btn-accent").onclick=()=>addToCart({id:f.id,name:f.name,price:f.price});
      }
      g.appendChild(card);
    });
}

document.getElementById("search").addEventListener("input", renderGrid);

fetch("api/foods.php")
  .then(r=>r.json())
  .then(d=>{
    foods=d.foods; categories=d.categories;
    renderTabs(); renderGrid();
  });
</script>
</body>
</html>
