<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Оформление</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <a class="muted" href="cart.php">← корзина</a>
  <h2>Оформление заказа</h2>

  <label>Номер компьютера</label>
  <input class="input" id="pc" placeholder="Напр. 12">

  <label style="margin-top:8px">Комментарий (по желанию)</label>
  <textarea class="input" id="comment" rows="3" placeholder="Напр. без лука, поострее"></textarea>

  <div class="notice" id="sum"></div>
  <button class="btn btn-accent" style="width:100%" id="send">Заказать</button>
</div>

<script src="/assets/js/app.js"></script>
<script>
const pcSaved = localStorage.getItem("pc_number");
if(pcSaved) document.getElementById("pc").value = pcSaved;

function hallByPC(pc){
  pc = parseInt(pc,10);
  if(pc>=1 && pc<=10) return "Force";
  if(pc>=21 && pc<=30) return "Elite (Bootcamp)";
  if(pc>=31 && pc<=51) return "Triumph";
  if(pc>=52 && pc<=61) return "Alienware";
  if(pc>=62 && pc<=66) return "Phantom";
  return "Stream / President";
}

function renderSum(){
  const c=getCart();
  let subtotal=0;
  c.forEach(x=>subtotal+=x.price*x.qty);
  const fee=Math.round(subtotal*0.10);
  const total=subtotal+fee;
  document.getElementById("sum").innerHTML=`
    <div>Сумма: <b>${subtotal} ₸</b></div>
    <div>Сервис 10%: <b>${fee} ₸</b></div>
    <div>Итого: <b>${total} ₸</b></div>
  `;
}
renderSum();

document.getElementById("send").onclick=()=>{
  const c=getCart();
  if(!c.length) return alert("Корзина пустая");
  const pc=document.getElementById("pc").value.trim();
  if(!pc) return alert("Введите номер компьютера");
  localStorage.setItem("pc_number", pc);

  fetch("api/order_create.php",{
    method:"POST",
    headers:{"Content-Type":"application/json"},
    body:JSON.stringify({
      pc_number:pc,
      hall_name:hallByPC(pc),
      comment:document.getElementById("comment").value.trim(),
      items:c
    })
  }).then(r=>r.json()).then(d=>{
    if(d.ok){
      localStorage.removeItem("triumph_cart_v1");
      location.href="order.php?id="+d.order_id;
    } else alert(d.error||"Ошибка заказа");
  });
};
</script>
</body>
</html>
