<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Корзина</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <a class="muted" href="index.php">← меню</a>
  <h2>Корзина</h2>

  <div id="list"></div>

  <div class="notice" id="sum"></div>
  <button class="btn btn-accent" style="width:100%" onclick="location.href='checkout.php'">Оформить заказ</button>
</div>

<script src="/assets/js/app.js"></script>
<script>
function render(){
  const c=getCart();
  const list=document.getElementById("list");
  list.innerHTML="";
  let subtotal=0;
  c.forEach(x=>{
    subtotal += x.price*x.qty;
    const row=document.createElement("div");
    row.className="notice";
    row.innerHTML=`
      <div class="row">
        <div><b>${x.name}</b><br><span class="muted">${x.price} ₸</span></div>
        <div class="space"></div>
        <button class="btn btn-ghost" onclick="setQty(${x.id}, ${x.qty-1}); render()">−</button>
        <div style="min-width:24px; text-align:center">${x.qty}</div>
        <button class="btn btn-ghost" onclick="setQty(${x.id}, ${x.qty+1}); render()">+</button>
      </div>
    `;
    list.appendChild(row);
  });
  const fee = Math.round(subtotal*0.10);
  const total = subtotal+fee;
  document.getElementById("sum").innerHTML=`
    <div>Сумма: <b>${subtotal} ₸</b></div>
    <div>Сервис 10%: <b>${fee} ₸</b></div>
    <div>Итого: <b>${total} ₸</b></div>
  `;
}
render();
</script>
</body>
</html>
