<?php
require_once __DIR__."/../config/db.php";
require_once __DIR__."/../config/auth.php";
require_role("owner");

$cats=$pdo->query("SELECT * FROM categories ORDER BY sort_order,id")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Категории</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo">Triumph • Категории</div>
    <div class="row">
      <a class="btn btn-ghost" href="dashboard.php">Заказы</a>
      <a class="btn btn-ghost" href="foods.php">Меню</a>
      <a class="btn btn-ghost" href="logout.php">Выйти</a>
    </div>
  </div>

  <form class="notice" method="post" action="api/categories_crud.php">
    <input type="hidden" name="action" value="create">
    <label>Новая категория</label>
    <div class="row">
      <input class="input" name="name" required>
      <button class="btn btn-accent">Добавить</button>
    </div>
  </form>

  <h3>Список</h3>
  <table class="table">
    <tr><th>ID</th><th>Название</th><th></th></tr>
    <?php foreach($cats as $c): ?>
    <tr>
      <td><?=$c['id']?></td>
      <td><?=$c['name']?></td>
      <td>
        <form method="post" action="api/categories_crud.php" onsubmit="return confirm('Удалить?')">
          <input type="hidden" name="action" value="delete">
          <input type="hidden" name="id" value="<?=$c['id']?>">
          <button class="btn btn-danger">Удалить</button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
</body>
</html>
