<?php
require_once __DIR__."/../../config/db.php";
require_once __DIR__."/../../config/auth.php";
require_login();
header("Content-Type: application/json");

$orders = $pdo->query("SELECT * FROM orders ORDER BY id DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC);
$itemsSt = $pdo->prepare("SELECT food_name,quantity FROM order_items WHERE order_id=?");

$map=[
  "NEW"=>"Новый","ACCEPTED"=>"Принят","COOKING"=>"Готовится",
  "READY"=>"Готово","DONE"=>"Выдан","CANCELED"=>"Отменён"
];

foreach($orders as &$o){
  $itemsSt->execute([$o['id']]);
  $o['items']=$itemsSt->fetchAll(PDO::FETCH_ASSOC);
  $o['status_ru']=$map[$o['status']] ?? $o['status'];
}
echo json_encode(["ok"=>true,"orders"=>$orders], JSON_UNESCAPED_UNICODE);
